/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.questkilltask.mixin;

import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbquests.FTBQuestsEventHandler;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.muon.questkilltask.DamageTracker;
import dev.muon.questkilltask.QuestProcessor;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FTBQuestsEventHandler.class}, remap=false)
public class FTBQuestsEventHandlerMixin {
    @Shadow(remap=false)
    private List<KillTask> killTasks;
    @Unique
    private QuestProcessor questKillTask$questProcessor;

    @Inject(method={"playerKill"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPlayerKill(class_1309 entity, class_1282 source, CallbackInfoReturnable<EventResult> cir) {
        if (this.questKillTask$questProcessor == null) {
            this.questKillTask$questProcessor = new QuestProcessor(this.killTasks);
        }
        if (!this.questKillTask$questProcessor.shouldProcessKill(entity)) {
            cir.setReturnValue((Object)EventResult.pass());
            return;
        }
        ServerQuestFile questFile = this.questKillTask$questProcessor.getQuestFile();
        if (questFile == null) {
            cir.setReturnValue((Object)EventResult.pass());
            return;
        }
        TeamData killerTeam = this.questKillTask$questProcessor.getKillerTeam(source, questFile);
        this.questKillTask$questProcessor.processDamagingTeams(entity, questFile, killerTeam);
        DamageTracker.clearEntityTracking(entity);
        cir.setReturnValue((Object)EventResult.pass());
    }
}

